	subroutine BC(iout, idbg, Nn, Nb, Np, Ng, Ns, BCe, BCn, BCvalue, BCtype, &
			C, T, Son, In, Ao, Vm, wg, Jib, a33, Shpb, dNdrb)
! update BC
! *** IMPORTANT: T is positive for outflow and negative for inflow ***
! NOTE: on the boundaries W = N by definition

	implicit none
	integer iout, idbg
	integer Nn, Nb, Np, Ng, Ns		! array parameters
	integer BCe(Nb,3)			! BC element numbers
	real*8 BCn(Nb,2)			! BC Nx's
	real*8 BCvalue(Nb,Ns,2)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('R', 'N' or 'D')
	real*8 C   (Nn,Ns), T   (Nn,Ns)		! global  arrays
	real*8 Son (Nn,Ns)			! global  arrays
	real*8 In(Nn,Ns,0:Np)			! convolution array M*C
	real*8 wg(Ng)				! Gauss weights
	real*8 Jib(2,2,Nb,Ng), a33(Nb)		! boundary geometric entities
	real*8 Shpb(2,Nb,Ng), dNdrb(2,2,Nb,Ng)	! boundary shape functions
	real*8 Ao(Nn), Vm(Nn,2)			! nodal averaged array

	integer i, j, k, n, p, s, g1b	! local indices
	integer ii			! global index
	real*8 BCv(2), Nx, Ny, w, Te(2), Ij(2), Vn(2), Fe(2,2)

!	write(idbg,'(a)') ' --- BC ---'	! ### TEMPORARY ###

! reset T to Son in case that a node has more than one BC
	T = Son		! use matrix form

	do s = 1, Ns
	  do n = 1, Nb
	    Nx = BCn(n,1)		! BC Nx
	    Ny = BCn(n,2)		! BC Ny
	    BCv(:) = BCvalue(n,s,:)	! BC value
! reset Te, Fe to 0
	    Te = 0.
	    Fe = 0.

	    if      (BCtype(n) .eq. 'R') then
! Robin BC
!---------
	      do i = 1,2
	        ii = BCe(n,i)				! BC global node i number
	        Vn(i) = Vm(ii,1)*Nx + Vm(ii,2)*Ny	! normal velocity at local node i
	        if(Np .eq. 0)	then
! for ADE
	          Ij(i) = C(ii,s)			! I <- C
	        else
! for EXP
	          Ij(i) = Ao(ii)*C(ii,s)		! Ao*C(i)
	          do p = 1, Np
	            Ij(i) = Ij(i) + In(ii,s,p)		! sum In(p,i) for node i
	          enddo	! p
	        endif
	      enddo	! i
	    
	      do g1b = 1, Ng
	        w = wg(g1b)
	        do i = 1,2
	          do j = 1,2
	            Te(i) = Te(i) + w * SHPb(i,n,g1b) * BCv(j) * SHPb(j,n,g1b) * a33(n)
! calculate integral[(W_I*n_i*v_i*N_J)]dG
	            Fe(i,j) = Fe(i,j) + w * SHPb(i,n,g1b) * Vn(i)* SHPb(j,n,g1b) * a33(n)
	          enddo	! j
	        enddo	! i
	      enddo	! g1b

! calculate and store in T
	      do i = 1,2
	        ii= BCe(n,i)				! BC global node i number
	        do j = 1,2
		  T(ii,s) = T(ii,s) - Fe(i,j)*Ij(j)	! add first term
	        enddo	! j
	        T(ii,s) = T(ii,s) + Te(i)		! add second term
	      enddo	! i

!	    else if (BCtype(n) .eq. 'D') then
! Dirichlet BC is implemented in INIT and SOLVE
!-------------

	    else if (BCtype(n) .eq. 'N') then
! Neumann BC
!-----------
	      do g1b = 1, Ng
	        w = wg(g1b)
	        do i = 1,2
	          do j = 1,2
	            Te(i) = Te(i) + w * SHPb(i,n,g1b) * BCv(j) * SHPb(j,n,g1b) * a33(n)
	          enddo		! j
	        enddo		! i
	      enddo		! g1b

! calculate and store in T
	      do i = 1,2
	        ii= BCe(n,i)				! BC global node i number
	        T(ii,s) = T(ii,s) + Te(i)		! add second term
	      enddo	! i

	    endif
	  enddo	! n
	enddo	! s

	return
	end

